/*
 * pgpPassCach.h -- A Passphrase Cache
 *
 * Written by:	Derek Atkins <warlord@MIT.EDU>
 *
 * $Id: pgpPassCach.h,v 1.6 2001/01/25 22:12:03 jeffc Exp $
 */

#ifndef Included_pgpPassCach_h
#define Included_pgpPassCach_h

#include "pgpUsuals.h"

PGP_BEGIN_C_DECLARATIONS

#include "pgpOpaqueStructs.h"
#include "pgpPubTypes.h"


	PGPError
pgpSecKeyUnlockWithCache( PGPSecKey *sec, PGPByte const *passphrase,
	PGPSize passphraseLength, PGPBoolean hashedPhrase, PGPUInt32 cacheTimeOut,
	PGPBoolean cacheGlobal );


	PGPError
pgpSecKeyCachePassphrase( PGPSecKey *sec, PGPByte const *passphrase,
	PGPSize passphraseLength, PGPBoolean hashedPhrase, PGPUInt32 cacheTimeOut,
	PGPBoolean cacheGlobal );

	void
pgpExpirePassphraseCache( PGPContextRef context );

	PGPError
pgpPurgePassphraseCache_internal( PGPContextRef context );


PGP_END_C_DECLARATIONS

#endif /* Included_pgpPassCach_h */
